import cv2
import math
import yaml
import time
import numpy as np
import copy
from scipy.optimize import minimize
from sys import argv
from numpy.linalg import inv
from scipy.optimize import minimize
from multiprocessing import Pool, cpu_count

#Признак отладочной печати
DEBUG_PRINT = True

#Построение матрицы камеры
def MakeCameraMatrix(fovX, size):
    f = size[0] / (math.tan(fovX / 2.0 ) * 2.0)
    cx = (size[0] / 2.0)
    cy = (size[1] / 2.0)
    return np.array([f, 0, cx, 0, f, cy, 0, 0, 1], dtype='f').reshape((3,3))


#Расчет внутренних параметров камер
def processing(argv):

    #Чтение параметров строки
    _, path_config = argv

    #Чтение конфигурационного файла
    with open(path_config) as fh:
        #Пропуск первой строки
        next(fh)
        #Чтение файла
        read_data = yaml.load(fh, Loader=yaml.FullLoader)

    #-------------- Извлечение конфигурационных параметров --------------#
    '''
    #Список наименований в пути
    names = path_config.split('/')
    #Путь к конфигурационному файлу
    path_data = ''
    #Цикл по наименованиям в пути
    for i in np.arange(len(names)-1):
        #Путь к конфигурационному файлу
        path_data += names[i] + '/'
    '''
    path_data = ''
    #Список имен камер
    cams = list(read_data['camera_streams'])
    #Список наименований файдов внутренних параметров
    intrinsics = read_data['intrinsics']
    #Наименование файла внешних параметров
    extrinsics = read_data['extrinsics']
    #Угол обзора камер
    view_ang = read_data['calibrate']['view_ang'] / 180 * math.pi
    #Положения камер
    positions = read_data['calibrate']['positions']
    #Размер изображения
    image_size = read_data['calibrate']['image_size']
    #Наименование файла параметров трансформации
    linear_regress = read_data['linear_regress']['tmp_file']

    #-------------- Формирование внешних параметров камер --------------#

    #Список матриц R
    Rt = []
    #Цикл по позициям
    for cam in positions:
        #Матрица поворота
        Rt.append(cv2.Rodrigues(np.array(positions[cam], dtype='f') / 180 * math.pi)[0])

    #-------------- Инициализация матрицы {T} --------------#
    
    file_t = open(path_data + linear_regress, "wt")
    file_t.write('%YAML:1.0' + '\n')
    file_t.write('---' + '\n')
    file_t.write('linear_regress:' + '\n')

    #Цикл по камерам
    for k in np.arange(len(cams)):
        file_t.write('   ' + cams[k] + ':\n')
        file_t.write('      alpha: ' + str(1.0) + '\n')
        file_t.write('      beta: ' + str(0.0) + '\n')
    
    #Закрытие файла
    file_t.close()

    #-------------- Сохранение матриц {R,T} --------------#
    
    file_t = open(path_data + extrinsics, "wt")
    file_t.write('%YAML:1.0' + '\n')
    file_t.write('---' + '\n')
    file_t.write('extrinsics:' + '\n')

    #Цикл по камерам
    for i in np.arange(len(cams)):
        file_t.write('   ' + cams[i] + ':\n')
        file_t.write('      R: !!opencv-matrix' + '\n')
        file_t.write('         rows: 3' + '\n')
        file_t.write('         cols: 3' + '\n')
        file_t.write('         dt: f' + '\n')
        file_t.write('         data: ' + str(list(Rt[i].reshape(-1))) + '\n')
        file_t.write('      T: ' + str([0., 0., 0.]) + '\n')
    
    #Закрытие файла
    file_t.close()

    #-------------- Сохранение матриц {K,D} --------------#

    #Построение матрицы камеры
    matr = MakeCameraMatrix(view_ang, image_size)
    #Цикл по списку файлов внутренних параметров
    for cam in intrinsics:
    
        file_t = open(path_data + intrinsics[cam], "wt")
        file_t.write('%YAML:1.0' + '\n')
        file_t.write('---' + '\n')

        file_t.write('K: !!opencv-matrix' + '\n')
        file_t.write('   rows: 3' + '\n')
        file_t.write('   cols: 3' + '\n')
        file_t.write('   dt: f' + '\n')
        file_t.write('   data: ' + str(list(matr.reshape(-1))) + '\n')
        file_t.write('D: !!opencv-matrix' + '\n')
        file_t.write('   rows: 1' + '\n')
        file_t.write('   cols: 4' + '\n')
        file_t.write('   dt: f' + '\n')
        file_t.write('   data: ' + str([0., 0., 0., 0.]) + '\n')
        file_t.write('frame_width: ' +  str(image_size[0]) + '\n')
        file_t.write('frame_height: ' +  str(image_size[1]) + '\n')
        file_t.write('model: pinhole\n')

        #Закрытие файла
        file_t.close()
        
    #Признак удачной калибровки
    return 1

#Основной метод обработки
processing(argv)
