import cv2
import math
import yaml
import numpy as np
from sys import argv
import os
import subprocess
import re

#Признак отладочной печати
DEBUG_PRINT = True
#Предельные значения дисторсий
Limits_d = (-0.3, 0.5)

#Построение матрицы камеры
def MakeCameraMatrix(fovX, size):
    f = size[0] / (math.tan(fovX / 2.0 ) * 2.0)
    cx = (size[0] / 2.0)
    cy = (size[1] / 2.0)
    return np.array([f, 0, cx, 0, f, cy, 0, 0, 1], dtype='f').reshape((3,3))

#Расчет маски пересечения изобрадений слева и справа
def processing(argv):

    #Чтение параметров строки
    _, path_config, cam_name = argv

    #Чтение конфигурационного файла
    with open(path_config) as fh:
        #Пропуск первой строки
        next(fh)
        #Чтение файла
        read_data = yaml.load(fh, Loader=yaml.FullLoader)

    #-------------- Извлечение конфигурационных параметров --------------#
    '''
    #Список наименований в пути
    names = path_config.split('/')
    #Путь к конфигурационному файлу
    path_data = ''
    #Цикл по наименованиям в пути
    for i in np.arange(len(names)-1):
        #Путь к конфигурационному файлу
        path_data += names[i] + '/'
    '''
    path_data = ''
    #Список имен камер
    #cams = list(read_data['camera_streams'])
    #Список наименований файдов внутренних параметров
    intrinsics = read_data['intrinsics']
    #Угол обзора камер
    view_ang = read_data['calibrate']['view_ang'] / 180 * math.pi
    #Потоки камер
    camera_streams = read_data['camera_streams']
    #Размер изображения
    image_size = read_data['calibrate']['image_size']
      
    #-------------- Загрузка параметров камер --------------#
    
    #Загрузка файла с внутренними парамтерами камеры
    int_data = cv2.FileStorage(path_data + intrinsics[cam_name], cv2.FILE_STORAGE_READ)
    #Внутренние параметры камер
    Km = int_data.getNode("K").mat(); Dm = int_data.getNode("D").mat()

    #Область RTSP
    os.environ['OPENCV_FFMPEG_CAPTURE_OPTIONS'] = 'rtsp_transport;udp'
    #Захват видеопотока
    cap = cv2.VideoCapture(camera_streams[cam_name]['url'])
    #Захват видеопотока
    #cap = cv2.VideoCapture(0)
    '''
    #Захват видео потока GStreamer
    def open_cam_rtsp(uri):
        #Командная строка gstreamer
        gst_str = ('{}').format(uri)
        print(gst_str)
        #Захват видео потока
        return cv2.VideoCapture(gst_str) 
    
    #Захват видео потока GStreamer
    cap = open_cam_rtsp(camera_streams[cam_name]['filename'])
    '''
    #Условие невозможности открыть видео поток
    if not cap.isOpened():
        #Отладочная печать
        print('\033[95m' + 'Ошибка открытия видеопотока...' + '\033[0m')
        #Выход
        return 0
    
    #Заголовок окна
    win_title = "Camera calibrate " + cam_name
    #Максимальное количество делений тракбар
    alpha_slider_max = 100
    #Событие на изменение тракбар 1
    def on_trackbar1(val): Dm[0][0] = Limits_d[0] * val / alpha_slider_max
    #Событие на изменение тракбар 2
    def on_trackbar2(val): Dm[0][1] = Limits_d[1] * val / alpha_slider_max

    #Создание формы окна
    cv2.namedWindow(win_title)
    #Тракбар
    cv2.createTrackbar('d0', win_title , int(Dm[0][0] * alpha_slider_max / Limits_d[0] + 0.5), alpha_slider_max, on_trackbar1)
    #Тракбар
    cv2.createTrackbar('d1', win_title , int(Dm[0][0] * alpha_slider_max / Limits_d[1] + 0.5), alpha_slider_max, on_trackbar2)

    #Цикл отображения видеоданных
    while True:
        #Изображение видеопотока
        _, img = cap.read()
        #Размеры изображения
        width, height, _ = img.shape
        
        #-------->Отображение сетки

        #Цвет сетки
        color_cell = 100
        #Количество шагов сетки 
        steps = 10
        #Избражение с сеткой
        overlay = img.copy()
        #Шаг сетки по высоте
        w_cell = int(width / steps + 0.5)
        #Цикл по высоте
        for y_s in np.arange(steps):
            #Отоюражение отрезка
            cv2.line(overlay, (0, y_s*w_cell), (height, y_s*w_cell), (color_cell, color_cell, color_cell), 1)

        #Шаг сетки по ширине
        h_cell = int(height / steps + 0.5)
        #Цикл по высоте
        for x_s in np.arange(steps):
            #Отоюражение отрезка
            cv2.line(overlay, (x_s*h_cell, 0), (x_s*h_cell, width), (color_cell, color_cell, color_cell), 1)

        # Transparency value
        alpha = 0.50
        # Perform weighted addition of the input image and the overlay
        img = cv2.addWeighted(overlay, alpha, img, 1 - alpha, 0)

        #-------->Отображение дисторсионного изображения

        #Коэффициент масштабирования
        coeff = min(1, 800 / width)
        #Размеры изображения
        width_new, height_new = int(width * coeff + 0.5), int(height * coeff + 0.5)
        #Изменение размера изображения
        img_scale = cv2.resize(img, (height_new, width_new), interpolation = cv2.INTER_LINEAR)
        #Построение матрицы камеры
        K_new = MakeCameraMatrix(view_ang, (height_new, width_new))
        #Матрица камеры
        newcameramatrix, _ = cv2.getOptimalNewCameraMatrix(K_new, Dm, (width_new, height_new), 1, (width_new, height_new))
        #Изображение без заданной дсторсии
        undistorted_image = cv2.undistort(img_scale, K_new, Dm, None, newcameramatrix)
        #Отображение видеопотока
        cv2.imshow(win_title, undistorted_image)

        #Условие нажатия клавиши ESC
        if cv2.waitKey(1) & 0xFF == 27:
            #Остановка видеопотока
            cap.release()
            #Выход
            break
    
    #Закрытие всех окон
    cv2.destroyAllWindows()

    #-------------- Сохранение матриц {K, D} --------------#

    #Запрос на подтверждение
    user_input = input('Сохранить настройки дисторсии для всех камер (yes/no): ')

    #Признак нажатия кнопки
    state = 0
    #Условие нажатия кнопки Y
    if user_input.lower() in ['yes', 'y']:
        #Признак нажатия кнопки
        state = 1
    #Условие нажатия кнопки N
    elif user_input.lower() in ['no', 'n']:
        #Признак нажатия кнопки
        state = 2

    #Список камер сохранения
    lst_cams = []
    #Цикл по всем камерам
    for cam in intrinsics:
        #Список камер сохранения
        if state == 1 or cam == cam_name: lst_cams.append(cam)
    
    #Сохранение 
    for cam in lst_cams:

        file_t = open(path_data + intrinsics[cam], "wt")
        file_t.write('%YAML:1.0' + '\n')
        file_t.write('---' + '\n')

        file_t.write('K: !!opencv-matrix' + '\n')
        file_t.write('   rows: 3' + '\n')
        file_t.write('   cols: 3' + '\n')
        file_t.write('   dt: f' + '\n')
        file_t.write('   data: ' + str(list(Km.reshape(-1))) + '\n')

        file_t.write('D: !!opencv-matrix' + '\n')
        file_t.write('   rows: 1' + '\n')
        file_t.write('   cols: 4' + '\n')
        file_t.write('   dt: f' + '\n')
        file_t.write('   data: ' + str(list(Dm.reshape(-1))) + '\n')

        file_t.write('frame_width: ' + str(image_size[0]) + '\n')
        file_t.write('frame_height: ' + str(image_size[1]) + '\n')
        file_t.write('model: pinhole' + '\n')
        
        #Закрытие файла
        file_t.close()

        #Отладочная печать
        if DEBUG_PRINT: print('Параметры дисторсии для ' + cam + ' сохранены...')

    #Признак удачной калибровки
    return 1

#Основной метод обработки
processing(argv)
